﻿//////////////////////////////////////////////
// CompilationResult.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Containers/String.h>

/// Class ------------------------------------

namespace nkScripts
{
	enum class COMPILATION_FAILURE_TYPE
	{
		NO_ERROR = 0,
		UNKNOWN,
		INTERPRETER_UNKNOWN,
		SYNTAX,
		MEMORY_ALLOCATION
	} ;

	struct CompilationResult final
	{
		// If failure, the message attached
		nkMemory::String _failureMessage ;
		// If failure, type of it
		COMPILATION_FAILURE_TYPE _failureType = COMPILATION_FAILURE_TYPE::NO_ERROR ;
		// If successful
		bool _success = true ;
	} ;
}

